using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;
//using System.Data.Common;

namespace Update {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        private SqlConnection cn; 
        private SqlDataAdapter da;
        private DataSet ds; 
        private DataView dv;
        private DataTable dt;
        private SqlParameter parm;
        private SqlCommand scSelect;
        private SqlCommand scInsert;
        private SqlCommand scUpdate;
        private SqlCommand scDelete;
        private int RowsAffected, intAdded, intModified, intOriginal, intCurrent, intDeleted;
        private int intModifiedCurrent, intModifiedOriginal, intUnchanged;
        internal System.Windows.Forms.Button btnShowVersions;
        internal System.Windows.Forms.Label Label2;
        internal System.Windows.Forms.TextBox txtModifiedCurrent;
        internal System.Windows.Forms.RadioButton rbContinueOnError;
        internal System.Windows.Forms.Panel Panel1;
        internal System.Windows.Forms.TextBox txtAuIDProposed;
        internal System.Windows.Forms.Button btnRequery;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.TextBox txtYear_Born;
        internal System.Windows.Forms.Button btnUpdate;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.TextBox txtAuthorProposed;
        internal System.Windows.Forms.TextBox txtYear_BornProposed;
        internal System.Windows.Forms.TextBox txtAuIDCurrent;
        internal System.Windows.Forms.Label Label3;
        internal System.Windows.Forms.TextBox txtAuthorCurrent;
        internal System.Windows.Forms.TextBox txtYear_BornCurrent;
        internal System.Windows.Forms.TextBox txtAuIDOriginal;
        internal System.Windows.Forms.Label Label4;
        internal System.Windows.Forms.TextBox txtAuthorOriginal;
        internal System.Windows.Forms.TextBox txtYear_BornOriginal;
        internal System.Windows.Forms.Label Label5;
        internal System.Windows.Forms.Label Label6;
        internal System.Windows.Forms.Label Label7;
        internal System.Windows.Forms.Label Label9;
        internal System.Windows.Forms.RadioButton rbStopOnError;
        internal System.Windows.Forms.TextBox txtCurrent;
        internal System.Windows.Forms.TextBox txtDelete;
        internal System.Windows.Forms.TextBox txtModifiedOriginal;
        internal System.Windows.Forms.TextBox txtOriginal;
        internal System.Windows.Forms.TextBox txtAdded;
        internal System.Windows.Forms.TextBox txtUnchanged;
        internal System.Windows.Forms.Label Label8;
        internal System.Windows.Forms.Label Label10;
        internal System.Windows.Forms.Label Label11;
        internal System.Windows.Forms.Label Label12;
        internal System.Windows.Forms.Label Label13;
        internal System.Windows.Forms.Label Label14;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();
                //
                // TODO: Add any constructor code after InitializeComponent call
                //   
                cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");
                da = new SqlDataAdapter();
                ds = new DataSet();

                scSelect = new SqlCommand("Author_Fetch", cn);
                scSelect.CommandType = CommandType.StoredProcedure;
                scSelect.Parameters.Add("@Year_Born", SqlDbType.SmallInt).Value = 100;
                scSelect.Parameters.Add("@Return_Value", SqlDbType.Int).Direction = ParameterDirection.ReturnValue;

                scInsert = new SqlCommand("AuthorInsert", cn);
                scInsert.CommandType = CommandType.StoredProcedure;
                scInsert.Parameters.Add("@Return_Value", SqlDbType.Int).Direction = ParameterDirection.ReturnValue;
                scInsert.Parameters.Add("@Author", SqlDbType.VarChar).SourceColumn = "Author";
                scInsert.Parameters.Add("@Year_Born", SqlDbType.SmallInt).SourceColumn = "Year_Born";

                scUpdate = new SqlCommand("AuthorUpdate", cn);
                scUpdate.CommandType = CommandType.StoredProcedure;
                scUpdate.Parameters.Add("@Return_Value", SqlDbType.Int).Direction = ParameterDirection.ReturnValue;
                scUpdate.Parameters.Add("@Author", SqlDbType.VarChar).SourceColumn = "Author";
                scUpdate.Parameters.Add("@Year_Born", SqlDbType.SmallInt).SourceColumn = "Year_Born";
                scUpdate.Parameters.Add("@Original_Au_ID", SqlDbType.Int).SourceColumn = "AU_ID";
                scUpdate.Parameters["@Original_Au_ID"].SourceVersion = DataRowVersion.Original;
                scUpdate.Parameters.Add("@Original_Author", SqlDbType.VarChar).SourceColumn = "Author";
                scUpdate.Parameters["@Original_Author"].SourceVersion = DataRowVersion.Original;
                scUpdate.Parameters.Add("@Original_Year_Born", SqlDbType.SmallInt).SourceColumn = "Year_Born";
                scUpdate.Parameters["@Original_Year_Born"].SourceVersion = DataRowVersion.Original;
                scUpdate.Parameters.Add("@Au_ID", SqlDbType.Int).SourceColumn = "AU_ID";
                scUpdate.Parameters["@Au_ID"].SourceVersion = DataRowVersion.Current;

                scDelete = new SqlCommand("AuthorDelete", cn);
                scDelete.CommandType = CommandType.StoredProcedure;
                scDelete.Parameters.Add("@Return_Value", SqlDbType.Int).Direction = ParameterDirection.ReturnValue;
                scDelete.Parameters.Add("@Original_Au_ID", SqlDbType.Int).SourceColumn = "AU_ID";
                scDelete.Parameters.Add("@Original_Author", SqlDbType.VarChar).SourceColumn = "Author";
                scDelete.Parameters.Add("@Original_Year_Born", SqlDbType.SmallInt).SourceColumn = "Year_Born";


                da.SelectCommand = scSelect;
                da.InsertCommand = scInsert;
                da.UpdateCommand = scUpdate;
                da.DeleteCommand = scDelete;

                DataGrid1.PreferredColumnWidth = 150;

                da.Fill(ds, "Authors");
                dt = ds.Tables["Authors"];

                // add a RowChanged event handler for the table.
                this.dt.RowChanged += new System.Data.DataRowChangeEventHandler(this.DataTableRow_Changed);
                DataGrid1.DataSource = ds.Tables["Authors"];
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
            this.btnShowVersions = new System.Windows.Forms.Button();
            this.Label2 = new System.Windows.Forms.Label();
            this.txtModifiedCurrent = new System.Windows.Forms.TextBox();
            this.rbContinueOnError = new System.Windows.Forms.RadioButton();
            this.Panel1 = new System.Windows.Forms.Panel();
            this.txtAuIDProposed = new System.Windows.Forms.TextBox();
            this.btnRequery = new System.Windows.Forms.Button();
            this.Label1 = new System.Windows.Forms.Label();
            this.txtYear_Born = new System.Windows.Forms.TextBox();
            this.btnUpdate = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.txtAuthorProposed = new System.Windows.Forms.TextBox();
            this.txtYear_BornProposed = new System.Windows.Forms.TextBox();
            this.txtAuIDCurrent = new System.Windows.Forms.TextBox();
            this.Label3 = new System.Windows.Forms.Label();
            this.txtAuthorCurrent = new System.Windows.Forms.TextBox();
            this.txtYear_BornCurrent = new System.Windows.Forms.TextBox();
            this.txtAuIDOriginal = new System.Windows.Forms.TextBox();
            this.Label4 = new System.Windows.Forms.Label();
            this.txtAuthorOriginal = new System.Windows.Forms.TextBox();
            this.txtYear_BornOriginal = new System.Windows.Forms.TextBox();
            this.Label5 = new System.Windows.Forms.Label();
            this.Label6 = new System.Windows.Forms.Label();
            this.Label7 = new System.Windows.Forms.Label();
            this.Label9 = new System.Windows.Forms.Label();
            this.rbStopOnError = new System.Windows.Forms.RadioButton();
            this.txtCurrent = new System.Windows.Forms.TextBox();
            this.txtDelete = new System.Windows.Forms.TextBox();
            this.txtModifiedOriginal = new System.Windows.Forms.TextBox();
            this.txtOriginal = new System.Windows.Forms.TextBox();
            this.txtAdded = new System.Windows.Forms.TextBox();
            this.txtUnchanged = new System.Windows.Forms.TextBox();
            this.Label8 = new System.Windows.Forms.Label();
            this.Label10 = new System.Windows.Forms.Label();
            this.Label11 = new System.Windows.Forms.Label();
            this.Label12 = new System.Windows.Forms.Label();
            this.Label13 = new System.Windows.Forms.Label();
            this.Label14 = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // btnShowVersions
            // 
            this.btnShowVersions.Location = new System.Drawing.Point(152, 304);
            this.btnShowVersions.Name = "btnShowVersions";
            this.btnShowVersions.Size = new System.Drawing.Size(136, 24);
            this.btnShowVersions.TabIndex = 49;
            this.btnShowVersions.Text = "Show Versions";
            this.btnShowVersions.Click += new System.EventHandler(this.btnShowVersions_Click);
            // 
            // Label2
            // 
            this.Label2.Location = new System.Drawing.Point(16, 248);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(40, 16);
            this.Label2.TabIndex = 46;
            this.Label2.Text = "Added";
            // 
            // txtModifiedCurrent
            // 
            this.txtModifiedCurrent.Location = new System.Drawing.Point(204, 276);
            this.txtModifiedCurrent.Name = "txtModifiedCurrent";
            this.txtModifiedCurrent.ReadOnly = true;
            this.txtModifiedCurrent.Size = new System.Drawing.Size(48, 20);
            this.txtModifiedCurrent.TabIndex = 40;
            this.txtModifiedCurrent.Text = "";
            // 
            // rbContinueOnError
            // 
            this.rbContinueOnError.Location = new System.Drawing.Point(32, 208);
            this.rbContinueOnError.Name = "rbContinueOnError";
            this.rbContinueOnError.Size = new System.Drawing.Size(144, 16);
            this.rbContinueOnError.TabIndex = 34;
            this.rbContinueOnError.Text = "Continue After Error?";
            this.rbContinueOnError.CheckedChanged += new System.EventHandler(this.rbContinueOnError_CheckedChanged);
            // 
            // Panel1
            // 
            this.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.Panel1.Location = new System.Drawing.Point(-16, 56);
            this.Panel1.Name = "Panel1";
            this.Panel1.Size = new System.Drawing.Size(568, 8);
            this.Panel1.TabIndex = 32;
            // 
            // txtAuIDProposed
            // 
            this.txtAuIDProposed.Location = new System.Drawing.Point(68, 148);
            this.txtAuIDProposed.Name = "txtAuIDProposed";
            this.txtAuIDProposed.ReadOnly = true;
            this.txtAuIDProposed.Size = new System.Drawing.Size(104, 20);
            this.txtAuIDProposed.TabIndex = 25;
            this.txtAuIDProposed.Text = "";
            // 
            // btnRequery
            // 
            this.btnRequery.Location = new System.Drawing.Point(168, 8);
            this.btnRequery.Name = "btnRequery";
            this.btnRequery.Size = new System.Drawing.Size(88, 24);
            this.btnRequery.TabIndex = 16;
            this.btnRequery.Text = "Query";
            this.btnRequery.Click += new System.EventHandler(this.btnRequery_Click);
            // 
            // Label1
            // 
            this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label1.Location = new System.Drawing.Point(-8, 8);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(80, 24);
            this.Label1.TabIndex = 15;
            this.Label1.Text = "Year Born";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // txtYear_Born
            // 
            this.txtYear_Born.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtYear_Born.Location = new System.Drawing.Point(88, 8);
            this.txtYear_Born.Name = "txtYear_Born";
            this.txtYear_Born.Size = new System.Drawing.Size(48, 22);
            this.txtYear_Born.TabIndex = 14;
            this.txtYear_Born.Text = "100";
            // 
            // btnUpdate
            // 
            this.btnUpdate.Enabled = false;
            this.btnUpdate.Font = new System.Drawing.Font("Trebuchet MS", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.btnUpdate.Location = new System.Drawing.Point(192, 184);
            this.btnUpdate.Name = "btnUpdate";
            this.btnUpdate.Size = new System.Drawing.Size(144, 32);
            this.btnUpdate.TabIndex = 13;
            this.btnUpdate.Text = "Update";
            this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.DataGrid1.Font = new System.Drawing.Font("Trebuchet MS", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.DataGrid1.Location = new System.Drawing.Point(0, 357);
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(512, 304);
            this.DataGrid1.TabIndex = 12;
            // 
            // txtAuthorProposed
            // 
            this.txtAuthorProposed.Location = new System.Drawing.Point(180, 148);
            this.txtAuthorProposed.Name = "txtAuthorProposed";
            this.txtAuthorProposed.ReadOnly = true;
            this.txtAuthorProposed.Size = new System.Drawing.Size(152, 20);
            this.txtAuthorProposed.TabIndex = 20;
            this.txtAuthorProposed.Text = "";
            // 
            // txtYear_BornProposed
            // 
            this.txtYear_BornProposed.Location = new System.Drawing.Point(340, 148);
            this.txtYear_BornProposed.Name = "txtYear_BornProposed";
            this.txtYear_BornProposed.ReadOnly = true;
            this.txtYear_BornProposed.Size = new System.Drawing.Size(56, 20);
            this.txtYear_BornProposed.TabIndex = 19;
            this.txtYear_BornProposed.Text = "";
            // 
            // txtAuIDCurrent
            // 
            this.txtAuIDCurrent.Location = new System.Drawing.Point(68, 124);
            this.txtAuIDCurrent.Name = "txtAuIDCurrent";
            this.txtAuIDCurrent.ReadOnly = true;
            this.txtAuIDCurrent.Size = new System.Drawing.Size(104, 20);
            this.txtAuIDCurrent.TabIndex = 18;
            this.txtAuIDCurrent.Text = "";
            // 
            // Label3
            // 
            this.Label3.Location = new System.Drawing.Point(-8, 152);
            this.Label3.Name = "Label3";
            this.Label3.Size = new System.Drawing.Size(80, 16);
            this.Label3.TabIndex = 31;
            this.Label3.Text = "Proposed";
            this.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // txtAuthorCurrent
            // 
            this.txtAuthorCurrent.Location = new System.Drawing.Point(180, 124);
            this.txtAuthorCurrent.Name = "txtAuthorCurrent";
            this.txtAuthorCurrent.ReadOnly = true;
            this.txtAuthorCurrent.Size = new System.Drawing.Size(152, 20);
            this.txtAuthorCurrent.TabIndex = 21;
            this.txtAuthorCurrent.Text = "";
            // 
            // txtYear_BornCurrent
            // 
            this.txtYear_BornCurrent.Location = new System.Drawing.Point(340, 124);
            this.txtYear_BornCurrent.Name = "txtYear_BornCurrent";
            this.txtYear_BornCurrent.ReadOnly = true;
            this.txtYear_BornCurrent.Size = new System.Drawing.Size(56, 20);
            this.txtYear_BornCurrent.TabIndex = 24;
            this.txtYear_BornCurrent.Text = "";
            // 
            // txtAuIDOriginal
            // 
            this.txtAuIDOriginal.Location = new System.Drawing.Point(68, 100);
            this.txtAuIDOriginal.Name = "txtAuIDOriginal";
            this.txtAuIDOriginal.ReadOnly = true;
            this.txtAuIDOriginal.Size = new System.Drawing.Size(104, 20);
            this.txtAuIDOriginal.TabIndex = 23;
            this.txtAuIDOriginal.Text = "";
            // 
            // Label4
            // 
            this.Label4.Location = new System.Drawing.Point(-8, 128);
            this.Label4.Name = "Label4";
            this.Label4.Size = new System.Drawing.Size(80, 16);
            this.Label4.TabIndex = 30;
            this.Label4.Text = "Current";
            this.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // txtAuthorOriginal
            // 
            this.txtAuthorOriginal.Location = new System.Drawing.Point(180, 100);
            this.txtAuthorOriginal.Name = "txtAuthorOriginal";
            this.txtAuthorOriginal.ReadOnly = true;
            this.txtAuthorOriginal.Size = new System.Drawing.Size(152, 20);
            this.txtAuthorOriginal.TabIndex = 17;
            this.txtAuthorOriginal.Text = "";
            // 
            // txtYear_BornOriginal
            // 
            this.txtYear_BornOriginal.Location = new System.Drawing.Point(340, 100);
            this.txtYear_BornOriginal.Name = "txtYear_BornOriginal";
            this.txtYear_BornOriginal.ReadOnly = true;
            this.txtYear_BornOriginal.Size = new System.Drawing.Size(56, 20);
            this.txtYear_BornOriginal.TabIndex = 22;
            this.txtYear_BornOriginal.Text = "";
            // 
            // Label5
            // 
            this.Label5.Location = new System.Drawing.Point(80, 80);
            this.Label5.Name = "Label5";
            this.Label5.Size = new System.Drawing.Size(80, 16);
            this.Label5.TabIndex = 27;
            this.Label5.Text = "Au_ID";
            this.Label5.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            // 
            // Label6
            // 
            this.Label6.Location = new System.Drawing.Point(216, 80);
            this.Label6.Name = "Label6";
            this.Label6.Size = new System.Drawing.Size(80, 16);
            this.Label6.TabIndex = 26;
            this.Label6.Text = "Author";
            this.Label6.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            // 
            // Label7
            // 
            this.Label7.Location = new System.Drawing.Point(328, 80);
            this.Label7.Name = "Label7";
            this.Label7.Size = new System.Drawing.Size(80, 16);
            this.Label7.TabIndex = 29;
            this.Label7.Text = "Year_Born";
            this.Label7.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
            // 
            // Label9
            // 
            this.Label9.Location = new System.Drawing.Point(-8, 104);
            this.Label9.Name = "Label9";
            this.Label9.Size = new System.Drawing.Size(80, 16);
            this.Label9.TabIndex = 28;
            this.Label9.Text = "Original";
            this.Label9.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // rbStopOnError
            // 
            this.rbStopOnError.Checked = true;
            this.rbStopOnError.Location = new System.Drawing.Point(32, 184);
            this.rbStopOnError.Name = "rbStopOnError";
            this.rbStopOnError.Size = new System.Drawing.Size(120, 16);
            this.rbStopOnError.TabIndex = 33;
            this.rbStopOnError.TabStop = true;
            this.rbStopOnError.Text = "Stop at first error";
            // 
            // txtCurrent
            // 
            this.txtCurrent.Location = new System.Drawing.Point(76, 276);
            this.txtCurrent.Name = "txtCurrent";
            this.txtCurrent.ReadOnly = true;
            this.txtCurrent.Size = new System.Drawing.Size(48, 20);
            this.txtCurrent.TabIndex = 41;
            this.txtCurrent.Text = "";
            // 
            // txtDelete
            // 
            this.txtDelete.Location = new System.Drawing.Point(140, 276);
            this.txtDelete.Name = "txtDelete";
            this.txtDelete.ReadOnly = true;
            this.txtDelete.Size = new System.Drawing.Size(48, 20);
            this.txtDelete.TabIndex = 39;
            this.txtDelete.Text = "";
            // 
            // txtModifiedOriginal
            // 
            this.txtModifiedOriginal.Location = new System.Drawing.Point(268, 276);
            this.txtModifiedOriginal.Name = "txtModifiedOriginal";
            this.txtModifiedOriginal.ReadOnly = true;
            this.txtModifiedOriginal.Size = new System.Drawing.Size(48, 20);
            this.txtModifiedOriginal.TabIndex = 35;
            this.txtModifiedOriginal.Text = "";
            // 
            // txtOriginal
            // 
            this.txtOriginal.Location = new System.Drawing.Point(324, 276);
            this.txtOriginal.Name = "txtOriginal";
            this.txtOriginal.ReadOnly = true;
            this.txtOriginal.Size = new System.Drawing.Size(48, 20);
            this.txtOriginal.TabIndex = 36;
            this.txtOriginal.Text = "";
            // 
            // txtAdded
            // 
            this.txtAdded.Location = new System.Drawing.Point(12, 276);
            this.txtAdded.Name = "txtAdded";
            this.txtAdded.ReadOnly = true;
            this.txtAdded.Size = new System.Drawing.Size(48, 20);
            this.txtAdded.TabIndex = 38;
            this.txtAdded.Text = "";
            // 
            // txtUnchanged
            // 
            this.txtUnchanged.Location = new System.Drawing.Point(380, 276);
            this.txtUnchanged.Name = "txtUnchanged";
            this.txtUnchanged.ReadOnly = true;
            this.txtUnchanged.Size = new System.Drawing.Size(48, 20);
            this.txtUnchanged.TabIndex = 37;
            this.txtUnchanged.Text = "";
            // 
            // Label8
            // 
            this.Label8.Location = new System.Drawing.Point(80, 248);
            this.Label8.Name = "Label8";
            this.Label8.Size = new System.Drawing.Size(48, 16);
            this.Label8.TabIndex = 47;
            this.Label8.Text = "Current";
            // 
            // Label10
            // 
            this.Label10.Location = new System.Drawing.Point(144, 248);
            this.Label10.Name = "Label10";
            this.Label10.Size = new System.Drawing.Size(40, 16);
            this.Label10.TabIndex = 48;
            this.Label10.Text = "Deleted";
            // 
            // Label11
            // 
            this.Label11.Location = new System.Drawing.Point(208, 240);
            this.Label11.Name = "Label11";
            this.Label11.Size = new System.Drawing.Size(48, 24);
            this.Label11.TabIndex = 43;
            this.Label11.Text = "Modified Current";
            // 
            // Label12
            // 
            this.Label12.Location = new System.Drawing.Point(272, 240);
            this.Label12.Name = "Label12";
            this.Label12.Size = new System.Drawing.Size(48, 24);
            this.Label12.TabIndex = 42;
            this.Label12.Text = "Modified Original";
            // 
            // Label13
            // 
            this.Label13.Location = new System.Drawing.Point(328, 248);
            this.Label13.Name = "Label13";
            this.Label13.Size = new System.Drawing.Size(48, 16);
            this.Label13.TabIndex = 45;
            this.Label13.Text = "Original";
            // 
            // Label14
            // 
            this.Label14.Location = new System.Drawing.Point(384, 248);
            this.Label14.Name = "Label14";
            this.Label14.Size = new System.Drawing.Size(64, 16);
            this.Label14.TabIndex = 44;
            this.Label14.Text = "Unchanged";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(512, 661);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.btnShowVersions,
                                                                          this.Label2,
                                                                          this.txtModifiedCurrent,
                                                                          this.rbContinueOnError,
                                                                          this.Panel1,
                                                                          this.txtAuIDProposed,
                                                                          this.btnRequery,
                                                                          this.Label1,
                                                                          this.txtYear_Born,
                                                                          this.btnUpdate,
                                                                          this.DataGrid1,
                                                                          this.txtAuthorProposed,
                                                                          this.txtYear_BornProposed,
                                                                          this.txtAuIDCurrent,
                                                                          this.Label3,
                                                                          this.txtAuthorCurrent,
                                                                          this.txtYear_BornCurrent,
                                                                          this.txtAuIDOriginal,
                                                                          this.Label4,
                                                                          this.txtAuthorOriginal,
                                                                          this.txtYear_BornOriginal,
                                                                          this.Label5,
                                                                          this.Label6,
                                                                          this.Label7,
                                                                          this.Label9,
                                                                          this.rbStopOnError,
                                                                          this.txtCurrent,
                                                                          this.txtDelete,
                                                                          this.txtModifiedOriginal,
                                                                          this.txtOriginal,
                                                                          this.txtAdded,
                                                                          this.txtUnchanged,
                                                                          this.Label8,
                                                                          this.Label10,
                                                                          this.Label11,
                                                                          this.Label12,
                                                                          this.Label13,
                                                                          this.Label14});
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "Form1";
            this.Text = "Update Example";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void btnRequery_Click(object sender, System.EventArgs e) {
            try{
                da.SelectCommand.Parameters["@Year_Born"].Value = txtYear_Born.Text;
                ds.Clear();
                da.Fill(ds, "Authors");
            }
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void ComputeRowCounts() {
            try {
                // Save the grid index--changing the RowStateFilter can change it
                int intDataGridIndex = DataGrid1.CurrentRowIndex;
                dv = ds.Tables["Authors"].DefaultView;

                Debug.WriteLine("---- " + DateTime.Now.ToLongDateString() + "------");
                dv.RowStateFilter = DataViewRowState.Added;
                Debug.WriteLine("Added:" + dv.Count);
                intAdded = dv.Count;
                txtAdded.Text = intAdded.ToString();

                dv.RowStateFilter = DataViewRowState.CurrentRows;
                Debug.WriteLine("Current Rows:" + dv.Count);
                intCurrent = dv.Count;
                txtCurrent.Text = intCurrent.ToString();

                dv.RowStateFilter = DataViewRowState.Deleted;
                Debug.WriteLine("Deleted:" + dv.Count);
                intDeleted = dv.Count;
                txtDelete.Text = intDeleted.ToString();

                dv.RowStateFilter = DataViewRowState.ModifiedCurrent;
                Debug.WriteLine("Modified Current:" + dv.Count);
                intModifiedCurrent = dv.Count;
                txtModifiedCurrent.Text = intModifiedCurrent.ToString();

                dv.RowStateFilter = DataViewRowState.ModifiedOriginal;
                Debug.WriteLine("Modified Original:" + dv.Count);
                intModifiedOriginal = dv.Count;
                txtModifiedOriginal.Text = intModifiedOriginal.ToString();

                dv.RowStateFilter = DataViewRowState.OriginalRows;
                Debug.WriteLine("Original Rows:" + dv.Count);
                intOriginal = dv.Count;
                txtOriginal.Text = intOriginal.ToString();

                dv.RowStateFilter = DataViewRowState.Unchanged;
                Debug.WriteLine("Unchanged:" + dv.Count);
                intUnchanged = dv.Count;
                txtUnchanged.Text = intUnchanged.ToString();

                dv.RowStateFilter = DataViewRowState.CurrentRows;
                DataGrid1.CurrentRowIndex = intDataGridIndex;
            }
            catch( Exception ex) {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
        
        private void ConcurrencyErrorMessage(DBConcurrencyException dbcx) {
            try {
                // Declare variables to hold the row versions for display 
                // in the message box.
                string strInDs = "Original record in DataSet:\r\n";
                string strInDB = "Current record in database:\r\n";
                string strProposed = "Proposed change:\r\n";
                string strPromptText = "Do you want to overwrite the current record in the database with the proposed change?\r\n";
                string strMessage;
                DialogResult response;

                // Loop through the column values.
                for(int i = 0; i < dbcx.Row.ItemArray.Length; i++) {
                    strInDs += dbcx.Row[i, DataRowVersion.Original].ToString() + "\t";
                    strInDB += dbcx.Row[i, DataRowVersion.Current].ToString() + "\t";
                    strProposed += ds.Tables["authors"].Rows[0][i, DataRowVersion.Current].ToString() + "\t";
                }

                // Create the message box text string.
                strMessage = strInDs + "\n" + strInDB + "\n" +
                    strProposed + "\n" + strPromptText;

                // Display the message box.
                response = MessageBox.Show(strMessage, dbcx.Message, MessageBoxButtons.YesNo);
                processResponse(response);
            }       
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }    
        }

        private void processResponse( DialogResult  response) {
            try {
                // Here is where you can get your user to indicate 
                // if they want to accept changes or undo edits.
                // Execute the appropriate code depending on the button 
                // selected in the message box.
                switch (response) {
                    case System.Windows.Forms.DialogResult.Yes:
                        // Overwrite the database with the proposed record.
                        // See text in the book to discuss what should go here.
                        goto case System.Windows.Forms.DialogResult.No;
                    case System.Windows.Forms.DialogResult.No:
                        ds.RejectChanges();  // Cancel proposed changes                            
                        break;
                }  
            }
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }    
        }



        private void btnUpdate_Click(object sender, System.EventArgs e) {
            try{ 
                btnUpdate.Enabled = false;
                // The expected RowsAffected value should be 
                // calculated as follows Original - Unchanged + Added
                ComputeRowCounts();
                intModified = intAdded + intDeleted + intModifiedOriginal;
                Debug.WriteLine("Rows Modified:" + intModified);

                DataTable dtChanges = new DataTable();
                int IntChanges;
                dtChanges = ds.Tables["Authors"].GetChanges();
                IntChanges = dtChanges.Rows.Count;
                if (IntChanges != intModified) {
                    MessageBox.Show("GetChanges count (" + IntChanges + ") does not match computed count (" + intModified + ").");
                }
                RowsAffected = da.Update(ds.Tables["Authors"]);
                ComputeRowCounts();
                ds.Tables["Authors"].AcceptChanges();
                // Test for update errors. Update won't trap if ContinueAfterError is true
                if (intModified != RowsAffected) {
                    MessageBox.Show("Something went wrong with the update. \r\nWe expected to update " + intModified + " rows, but actually affected " + RowsAffected + " rows.","Update Example",MessageBoxButtons.OK, MessageBoxIcon.Stop);
                }
                if( ds.HasErrors) {
                    // Okay, there are errors somewhere in the DataTable--go look for them
                    string errStr = "";
                    foreach ( DataRow dr in ds.Tables["Authors"].GetErrors()) {
                        errStr = errStr + "Au_ID = " + dr["Au_ID"].ToString() +
                            " Author:" + dr["Author"].ToString() +
                            " Born:" + dr["Year_Born"].ToString() + " Error = " + dr.RowError + "\n\r"; }
                    MessageBox.Show(errStr,"DataTable Error",MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
            }

            catch (SqlException sex) {
                MessageBox.Show(sex.Message);
            }
            catch (DBConcurrencyException dbconex){
                if (dbconex.Row.HasErrors ) {
                    ConcurrencyErrorMessage(dbconex);
                    dbconex.Row.ClearErrors();
                }
                else {
                    MessageBox.Show("We got an exception with no errors on the row passed");
                }
                ShowVersions(DataGrid1.CurrentCell.RowNumber);
            }
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }    
        }
        
        private void ShowVersions(int dgRowNumber) {
            try {
                DataRow dr = ds.Tables[0].Rows[dgRowNumber];
                string strNa = "Not available";

                if (dr.HasVersion(DataRowVersion.Current)) {
                    txtAuIDCurrent.Text = dr["Au_ID", DataRowVersion.Current].ToString();
                    txtAuthorCurrent.Text = dr["Author", DataRowVersion.Current].ToString();
                    txtYear_BornCurrent.Text = dr["Year_Born", DataRowVersion.Current].ToString();
                }
                else {
                    txtAuIDCurrent.Text = strNa;
                    txtAuthorCurrent.Text = strNa;
                    txtYear_BornCurrent.Text = "N/A";
                }
                if( dr.HasVersion(DataRowVersion.Proposed)) {
                    txtAuIDProposed.Text = dr["Au_ID", DataRowVersion.Proposed].ToString();
                    txtAuthorProposed.Text = dr["Author", DataRowVersion.Proposed].ToString();
                    txtYear_BornProposed.Text = dr["Year_Born", DataRowVersion.Proposed].ToString();
                }
                else {
                    txtAuIDProposed.Text = strNa;
                    txtAuthorProposed.Text = strNa;
                    txtYear_BornProposed.Text = "N/A";

                }
                if (dr.HasVersion(DataRowVersion.Original)) {
                    txtAuIDOriginal.Text = dr["Au_ID", DataRowVersion.Original].ToString();
                    txtAuthorOriginal.Text = dr["Author", DataRowVersion.Original].ToString();
                    txtYear_BornOriginal.Text = dr["Year_Born", DataRowVersion.Original].ToString();
                }
                else{
                    txtAuIDOriginal.Text = strNa;
                    txtAuthorOriginal.Text = strNa;
                    txtYear_BornOriginal.Text = "N/A";
                }
                ComputeRowCounts();
            }
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }    

        }
        
        private void ValidateRow(DataRow dr) {
            try {
                int intYb;
                if (dr["Year_born"].Equals(DBNull.Value)) {
                    return;
                }
                intYb = Convert.ToInt32(dr["Year_Born"]);
                if ((intYb < 1)  | (intYb > 2100)) {
                    MessageBox.Show("Year born value is invalid");
                    dr.RejectChanges();  // Cancel proposed changes
                }
            }
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            } 
        }

        private void DataTableRow_Changed(object Sender, System.Data.DataRowChangeEventArgs e) {
            try {
                // The DataRow has changed. Validate the contents
                string strA="";
                btnUpdate.Enabled = true;

                switch ( e.Action) {
                    case DataRowAction.Add:
                        strA = "Add";
                        ValidateRow(e.Row);
                        break;
                    case DataRowAction.Change:
                        strA = "Change";
                        ValidateRow(e.Row);
                        break;
                    case DataRowAction.Commit:
                        strA = "Commit";
                        break;
                    case DataRowAction.Delete:
                        strA = "Delete";
                        if (MessageBox.Show("Are you sure you want to delete this row?",
                            "Question", MessageBoxButtons.OKCancel ,
                            MessageBoxIcon.Question,
                            MessageBoxDefaultButton.Button1)
                            == DialogResult.Cancel ) {
                            e.Row.RejectChanges();  // Cancel proposed changes
                        }
                        break;

                    case  DataRowAction.Nothing:
                        strA = "Nothing";
                        break;
                    case DataRowAction.Rollback:
                        strA = "Rollback";
                        break;
                }
                Debug.WriteLine("Row_Changed Event: AU_ID=" + e.Row["Au_ID"].ToString() + " -- " + strA);
            }  
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }    
        }
       
        private void btnShowVersions_Click(object sender, System.EventArgs e) {
            try{
                int i = DataGrid1.CurrentRowIndex;
                ShowVersions(DataGrid1.CurrentCell.RowNumber);
            }
            catch (Exception ex){
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }    
        }

        private void rbContinueOnError_CheckedChanged(object sender, System.EventArgs e) {
             da.ContinueUpdateOnError = rbContinueOnError.Checked;
        }
    }
}